<?php
/**
 * PHP file wsp\class\display\JavaScript.class.php
 * @package display
 */
/**
 * Class JavaScript
 *
 * WebSite-PHP : PHP Framework 100% object (http://www.website-php.com)
 * Copyright (c) 2009-2011 WebSite-PHP.com
 * PHP versions >= 5.2
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 * 
 * @package display
 * @author      Emilien MOREL <admin@website-php.com>
 * @link        http://www.website-php.com
 * @copyright   WebSite-PHP.com 26/05/2011
 * @version     1.0.89
 * @access      public
 * @since       1.0.17
 */

class JavaScript extends WebSitePhpObject {
	/**#@+
	* @access private
	*/
	private $code_javascript = "";
	private $display_from_url = false;
	/**#@-*/

	/**
	 * Constructor JavaScript
	 * @param string $code_javascript 
	 * @param boolean $add_js_to_page [default value: false]
	 */
	function __construct($code_javascript, $add_js_to_page=false) {
		parent::__construct();
		
		if (!isset($code_javascript)) {
			throw new NewException("1 argument for ".get_class($this)."::__construct() is mandatory", 0, 8, __FILE__, __LINE__);
		}
		
		$this->code_javascript = $code_javascript;
		$this->is_javascript_object = true;
		
		if ($add_js_to_page) {
			$page_object = Page::getInstance($_GET['p']);;
			$page_object->addObject($this);
		}
	}
	
	/**
	 * Method displayFormURL
	 * @access public
	 * @return JavaScript
	 * @since 1.0.63
	 */
	public function displayFormURL() {
		$this->display_from_url = true;
		return $this;
	}
	
	/**
	 * Method render
	 * @access public
	 * @param boolean $ajax_render [default value: false]
	 * @return mixed
	 * @since 1.0.35
	 */
	public function render($ajax_render=false) {
		$js = "";
		if ($this->display_from_url) {
			$js .= "javascript:";
		}
		if (gettype($this->code_javascript) == "object" && method_exists($this->code_javascript, "render")) {
			$js .= $this->code_javascript->render($ajax_render);
		} else {
			$js .= $this->code_javascript;
		}
		return $js;
	}
	
	/**
	 * Method getAjaxRender
	 * @access public
	 * @return string javascript code to update initial html with ajax call
	 * @since 1.0.35
	 */
	public function getAjaxRender() {
		return str_replace("//<![CDATA[", "", str_replace("//]]>", "", str_replace("\n", "", str_replace("\r", "", $this->render(true)))));
	}
}
?>
